#!/bin/sh

# First the adress we want to update, CHANGE THIS to your address
hostname=example.example.org

# Second the login:pass we'll use, CHANGE THIS to your login and password
cred='login:pass'

# Get IP adress from Loopia
myip=`curl -s dyndns.loopia.com/checkip | sed 's/^.*: \([^<]*\).*$/\1/'`

# Check that we actually got anything
if [ x"$myip" = x ]
then
  echo Failed to get IP. Exiting.
  exit 255
fi

# Check that we actually got anything more or less sane
# Should really check that it's actually is an ipadress
# on the format 1.2.3.4 where each number is less than 256.
fmyip=`echo "$myip" | tr -cd '0-9.'`

if [ x"$fmyip" != x"$myip" ]
then
  echo Failed to understand IP received: "$myip"
  echo Exiting
  exit 255
fi

# Check if we already set this ip-adress
# We should really check DNS but since there is no good
# general command line that works similar on most UNIX
# we can't rely on it.
tempdir="$TMP"
[ x"$tempdir" = x ] && tempdir="$TMPDIR"
[ x"$tempdir" = x ] && tempdir=/tmp

ipfile="$tempdir"/"$hostname".ip
if [ -r "$ipfile" ]
then
  fmyip=`grep '^'"$myip"'$' "$ipfile"`

  if [ x"$myip" = x"$fmyip" ]
  then
    #echo No change detected. Wont run update.
    exit 0
  fi
fi

# Base URL
burl=https://dyndns.loopia.com/

# Extra options
eops='wildcard=NOCHG'

# Build URL
url="$burl"'?hostname='"$hostname"'&'myip="$myip"'&'"$eops"

result=`curl -s --user "$cred" "$url"`
if [ "$result" = nochg ]
then
  # Store the IP for future updates
  if [ -d "$tempdir" -a -w "$tempdir" ]
  then
    echo "$myip" > "$ipfile"
  else
    echo Warning, tempdir do not exist or is not writable: "$tempdir"
  fi
fi
echo "$result"
